/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Image;

class Bookmark {
    String url;
    String title;
    int serverBID;
    int clientBID;
    int folderServerBID;
    int folderClientBID;
    int state;
    boolean isFolder = false;
    private static byte[] bookmarkBytes = null;
    private static Bookmark[] bookmark = null;
    private static Bookmark[] sendingBookmark = null;
    static long lastAccessTime = 0L;
    private static int appliID = 0;
    private static int nextClientBID;
    private static boolean[] usedFlg;
    int type;
    int data1;
    int data2;
    Image im;
    int[] array;

    Bookmark(int n, int n2, int n3, int n4, int n5, boolean bl, String string, String string2) {
        this.state = n;
        this.serverBID = n2;
        this.clientBID = n3;
        this.folderServerBID = n4;
        this.folderClientBID = n5;
        this.title = string;
        this.url = string2;
        this.isFolder = bl;
    }

    static byte[] encodeBookmarkBytes(Bookmark[] bookmarkArray, int n, int n2, long l) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(Bookmark.long2Bytes(l, 6));
        byteArrayOutputStream.write(Bookmark.int2Bytes(n, 4));
        byteArrayOutputStream.write(Bookmark.int2Bytes(n2, 4));
        byteArrayOutputStream.write(Bookmark.int2Bytes(bookmarkArray.length, 2));
        for (int i = 0; i < bookmarkArray.length; ++i) {
            Bookmark bookmark = bookmarkArray[i];
            byteArrayOutputStream.write(bookmark.state);
            byteArrayOutputStream.write(Bookmark.int2Bytes(bookmark.serverBID, 4));
            byteArrayOutputStream.write(Bookmark.int2Bytes(bookmark.clientBID, 4));
            if (bookmarkArray[i].state != 0) continue;
            byteArrayOutputStream.write(Bookmark.int2Bytes(bookmark.folderServerBID, 4));
            byteArrayOutputStream.write(Bookmark.int2Bytes(bookmark.folderClientBID, 4));
            byteArrayOutputStream.write(bookmark.isFolder ? 1 : 0);
            byte[] byArray = Bookmark.getBytes(bookmark.title);
            byteArrayOutputStream.write(Bookmark.int2Bytes(byArray.length, 2));
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = Bookmark.getBytes(bookmark.url);
            byteArrayOutputStream.write(Bookmark.int2Bytes(byArray2.length, 2));
            byteArrayOutputStream.write(byArray2);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        byteArrayOutputStream = null;
        return byArray;
    }

    static long getLastAccessTime(byte[] byArray) {
        return Bookmark.bytes2Long(byArray, 1, 6);
    }

    static int getUserID(byte[] byArray) {
        return Bookmark.bytes2Int(byArray, 7, 4);
    }

    static int getAppliID(byte[] byArray) {
        return Bookmark.bytes2Int(byArray, 11, 4);
    }

    static Bookmark[] decodeBookmarkBytes(byte[] byArray) {
        int n;
        int n2 = 0;
        if ((n = byArray[n2++] & 0xFF) != 0) {
            return null;
        }
        Bookmark[] bookmarkArray = new Bookmark[Bookmark.bytes2Int(byArray, n2 += 14, 2)];
        n2 += 2;
        for (int i = 0; i < bookmarkArray.length; ++i) {
            int n3 = byArray[n2++] & 0xFF;
            int n4 = Bookmark.bytes2Int(byArray, n2, 4);
            int n5 = 0;
            n5 = Bookmark.bytes2Int(byArray, n2 += 4, 4);
            n2 += 4;
            if (n3 == 0) {
                int n6 = Bookmark.bytes2Int(byArray, n2, 4);
                int n7 = Bookmark.bytes2Int(byArray, n2 += 4, 4);
                n2 += 4;
                boolean bl = (byArray[n2++] & 0xFF) == 1;
                int n8 = Bookmark.bytes2Int(byArray, n2, 2);
                String string = new String(byArray, n2 += 2, n8);
                n2 += n8;
                n8 = Bookmark.bytes2Int(byArray, n2, 2);
                String string2 = new String(byArray, n2 += 2, n8);
                n2 += n8;
                bookmarkArray[i] = new Bookmark(n3, n4, n5, n6, n7, bl, string, string2);
                continue;
            }
            bookmarkArray[i] = new Bookmark(n3, n4, n5, 0, 0, false, "", "");
        }
        return bookmarkArray;
    }

    static byte[] int2Bytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(n >> (n2 - i - 1) * 8 & 0xFF);
        }
        return byArray;
    }

    static byte[] long2Bytes(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l >> (n - i - 1) * 8 & 0xFFL);
        }
        return byArray;
    }

    static int bytes2Int(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 |= (byArray[i] & 0xFF) << 8 * (n2 - (i - n) - 1);
        }
        return n3;
    }

    static long bytes2Long(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            l |= (long)(byArray[i] & 0xFF) << 8 * (n2 - (i - n) - 1);
        }
        return l;
    }

    static byte[] getBytes(String string) {
        if (string == null) {
            return new byte[0];
        }
        return string.getBytes();
    }

    static void readBookmark(int n) {
        byte[] byArray = C.readSP(21480, 20480);
        lastAccessTime = Bookmark.getLastAccessTime(byArray);
        n = Bookmark.getUserID(byArray);
        appliID = Bookmark.getAppliID(byArray);
        bookmark = Bookmark.decodeBookmarkBytes(byArray);
        byArray = C.readSP(41960, 20480);
        sendingBookmark = Bookmark.decodeBookmarkBytes(byArray);
        nextClientBID = Bookmark.bytes2Int(C.readSP(62440, 4), 0, 4);
        if (nextClientBID == 0) {
            nextClientBID = 1;
        }
    }

    static Bookmark[] getList() {
        if (bookmark == null) {
            Bookmark.readBookmark(0);
        }
        return bookmark;
    }

    static Bookmark[] getList(int n) {
        if (bookmark == null) {
            Bookmark.readBookmark(0);
        }
        int n2 = 0;
        for (int i = 0; i < bookmark.length; ++i) {
            if (Bookmark.bookmark[i].folderClientBID != n) continue;
            ++n2;
        }
        Bookmark[] bookmarkArray = new Bookmark[n2];
        n2 = 0;
        for (int i = 0; i < bookmark.length; ++i) {
            if (Bookmark.bookmark[i].folderClientBID != n) continue;
            bookmarkArray[n2] = bookmark[i];
            ++n2;
        }
        return bookmarkArray;
    }

    static void addNewBookmark(String string, String string2, int n, int n2) {
        Bookmark bookmark = new Bookmark(0, 0, 0, n, n2, false, string, string2);
        Bookmark.addNewBookmark(bookmark);
    }

    private static void addNewBookmark(Bookmark bookmark) {
        int n = nextClientBID;
        for (int i = 0; i < Bookmark.bookmark.length; ++i) {
            if (n > Bookmark.bookmark[i].clientBID + 1) continue;
            n = Bookmark.bookmark[i].clientBID + 1;
        }
        bookmark.clientBID = n;
        nextClientBID = n + 1;
        Bookmark[] bookmarkArray = new Bookmark[Bookmark.bookmark.length + 1];
        System.arraycopy(Bookmark.bookmark, 0, bookmarkArray, 0, Bookmark.bookmark.length);
        bookmarkArray[Bookmark.bookmark.length] = bookmark;
        Bookmark.bookmark = bookmarkArray;
        bookmarkArray = new Bookmark[sendingBookmark.length + 1];
        System.arraycopy(sendingBookmark, 0, bookmarkArray, 0, sendingBookmark.length);
        bookmarkArray[Bookmark.sendingBookmark.length] = bookmark;
        sendingBookmark = bookmarkArray;
    }

    static int addNewFolder(String string, int n, int n2) {
        Bookmark bookmark = new Bookmark(0, 0, 0, n, n2, true, string, "");
        Bookmark.addNewBookmark(bookmark);
        return nextClientBID - 1;
    }

    static void sendAllBookmark() {
        if (appliID == 0 || bookmark == null) {
            return;
        }
        sendingBookmark = new Bookmark[1];
        Bookmark.sendingBookmark[0] = new Bookmark(4, 0, 0, 0, 0, false, "", "");
        block0: for (int i = 0; i < bookmark.length; ++i) {
            Bookmark bookmark = Bookmark.bookmark[i];
            if (bookmark.serverBID == 0) continue;
            bookmark.serverBID = 0;
            bookmark.folderServerBID = 0;
            for (int j = 0; j < sendingBookmark.length; ++j) {
                if (Bookmark.sendingBookmark[j].state == 0 && Bookmark.sendingBookmark[j].clientBID == bookmark.clientBID) continue block0;
            }
            Bookmark[] bookmarkArray = new Bookmark[sendingBookmark.length + 1];
            System.arraycopy(sendingBookmark, 0, bookmarkArray, 0, sendingBookmark.length);
            bookmarkArray[Bookmark.sendingBookmark.length] = bookmark;
            sendingBookmark = bookmarkArray;
        }
    }

    static void sendRecoverFlag() {
        if (appliID == 0 || bookmark == null) {
            return;
        }
        sendingBookmark = new Bookmark[1];
        Bookmark.sendingBookmark[0] = new Bookmark(5, 0, 0, 0, 0, false, "", "");
        bookmark = new Bookmark[0];
        lastAccessTime = 0L;
    }

    static void editBookmark(Bookmark bookmark, String string, String string2, int n) {
        int n2;
        bookmark.title = string;
        bookmark.url = string2;
        bookmark.folderClientBID = n;
        bookmark.folderServerBID = 0;
        for (n2 = 0; n2 < Bookmark.bookmark.length; ++n2) {
            if (Bookmark.bookmark[n2].clientBID != bookmark.folderClientBID) continue;
            bookmark.folderServerBID = Bookmark.bookmark[n2].serverBID;
        }
        n2 = 0;
        for (int i = 0; i < sendingBookmark.length; ++i) {
            if (Bookmark.sendingBookmark[i].clientBID != bookmark.clientBID) continue;
            Bookmark.sendingBookmark[i] = bookmark;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            Bookmark[] bookmarkArray = new Bookmark[sendingBookmark.length + 1];
            System.arraycopy(sendingBookmark, 0, bookmarkArray, 0, sendingBookmark.length);
            bookmarkArray[Bookmark.sendingBookmark.length] = bookmark;
            sendingBookmark = bookmarkArray;
        }
    }

    static void writeBookmark(int n) throws Exception {
        usedFlg = new boolean[bookmark.length];
        Bookmark.checkBookmark(bookmark, 0);
        Bookmark[] bookmarkArray = new Bookmark[bookmark.length];
        int n2 = 0;
        for (int i = 0; i < usedFlg.length; ++i) {
            if (!usedFlg[i]) continue;
            bookmarkArray[n2++] = bookmark[i];
        }
        bookmark = new Bookmark[n2];
        System.arraycopy(bookmarkArray, 0, bookmark, 0, bookmark.length);
        byte[] byArray = Bookmark.encodeBookmarkBytes(bookmark, n, appliID, lastAccessTime);
        byte[] byArray2 = Bookmark.encodeBookmarkBytes(sendingBookmark, n, appliID, lastAccessTime);
        if (byArray.length > 20480 || byArray2.length > 20480) {
            throw new Exception();
        }
        C.writeSP(62440, Bookmark.int2Bytes(nextClientBID, 4));
        C.writeSP(21480, byArray);
        C.writeSP(41960, byArray2);
    }

    static void checkBookmark(Bookmark[] bookmarkArray, int n) {
        for (int i = 0; i < bookmarkArray.length; ++i) {
            if (bookmarkArray[i].folderClientBID != n || usedFlg[i]) continue;
            Bookmark.usedFlg[i] = true;
            Bookmark.checkBookmark(bookmarkArray, bookmarkArray[i].clientBID);
        }
    }

    static byte[] getSendData(int n) throws Exception {
        return Bookmark.encodeBookmarkBytes(sendingBookmark, n, appliID, lastAccessTime);
    }

    static void readReceivedData(byte[] byArray) throws Exception {
        int n;
        int n2;
        Bookmark.getUserID(byArray);
        appliID = Bookmark.getAppliID(byArray);
        lastAccessTime = Bookmark.getLastAccessTime(byArray);
        Bookmark[] bookmarkArray = Bookmark.decodeBookmarkBytes(byArray);
        boolean bl = false;
        boolean bl2 = false;
        block0: for (int i = 0; i < bookmarkArray.length; ++i) {
            if (bookmarkArray[i].state == 3) {
                for (n2 = 0; n2 < bookmark.length; ++n2) {
                    if (Bookmark.bookmark[n2].clientBID != bookmarkArray[i].clientBID) continue;
                    Bookmark.bookmark[n2].serverBID = bookmarkArray[i].serverBID;
                    if (!Bookmark.bookmark[n2].isFolder) continue;
                    for (n = 0; n < bookmark.length; ++n) {
                        if (Bookmark.bookmark[n2].clientBID != Bookmark.bookmark[n].folderClientBID) continue;
                        Bookmark.bookmark[n].folderServerBID = Bookmark.bookmark[n2].serverBID;
                    }
                }
                continue;
            }
            if (bookmarkArray[i].state == 0) {
                n2 = 0;
                for (n = 0; n < bookmark.length; ++n) {
                    int n3;
                    if (Bookmark.bookmark[n].serverBID != bookmarkArray[i].serverBID) continue;
                    Bookmark.bookmark[n].title = bookmarkArray[i].title;
                    Bookmark.bookmark[n].url = bookmarkArray[i].url;
                    Bookmark.bookmark[n].folderServerBID = bookmarkArray[i].folderServerBID;
                    if (Bookmark.bookmark[n].folderServerBID != 0) {
                        for (n3 = 0; n3 < bookmark.length; ++n3) {
                            if (Bookmark.bookmark[n3].serverBID != Bookmark.bookmark[n].folderServerBID) continue;
                            Bookmark.bookmark[n].folderClientBID = Bookmark.bookmark[n3].clientBID;
                            break;
                        }
                    } else {
                        Bookmark.bookmark[n].folderClientBID = 0;
                    }
                    if (Bookmark.bookmark[n].isFolder) {
                        for (n3 = 0; n3 < bookmarkArray.length; ++n3) {
                            if (Bookmark.bookmark[n].serverBID != bookmarkArray[n3].folderServerBID) continue;
                            bookmarkArray[n3].folderClientBID = Bookmark.bookmark[n].clientBID;
                        }
                        for (n3 = 0; n3 < bookmark.length; ++n3) {
                            if (Bookmark.bookmark[n].serverBID != Bookmark.bookmark[n3].folderServerBID) continue;
                            Bookmark.bookmark[n3].folderClientBID = Bookmark.bookmark[n].clientBID;
                        }
                    }
                    n2 = 1;
                    break;
                }
                if (n2 != 0) continue;
                Bookmark.addNewBookmark(bookmarkArray[i]);
                if (bookmarkArray[i].isFolder) {
                    for (n = 0; n < bookmarkArray.length; ++n) {
                        if (bookmarkArray[i].serverBID != bookmarkArray[n].folderServerBID) continue;
                        bookmarkArray[n].folderClientBID = bookmarkArray[i].clientBID;
                    }
                    for (n = 0; n < bookmark.length; ++n) {
                        if (bookmarkArray[i].serverBID != Bookmark.bookmark[n].folderServerBID) continue;
                        Bookmark.bookmark[n].folderClientBID = bookmarkArray[i].clientBID;
                    }
                }
                for (n = 0; n < bookmark.length; ++n) {
                    if (Bookmark.bookmark[n].serverBID != bookmarkArray[i].folderServerBID) continue;
                    bookmarkArray[i].folderClientBID = Bookmark.bookmark[n].clientBID;
                    continue block0;
                }
                continue;
            }
            if (bookmarkArray[i].state == 1) {
                Bookmark.deleteBookmark(bookmark, bookmarkArray[i]);
                continue;
            }
            if (bookmarkArray[i].state == 4) {
                bl = true;
                continue;
            }
            if (bookmarkArray[i].state != 5) continue;
            bl2 = true;
        }
        Bookmark[] bookmarkArray2 = new Bookmark[bookmark.length];
        n2 = 0;
        for (n = 0; n < bookmark.length; ++n) {
            if (Bookmark.bookmark[n].state == 2 || Bookmark.bookmark[n].state == 1 || Bookmark.bookmark[n].serverBID <= 0 || Bookmark.bookmark[n].clientBID <= 0) continue;
            bookmarkArray2[n2++] = bookmark[n];
        }
        bookmark = new Bookmark[n2];
        System.arraycopy(bookmarkArray2, 0, bookmark, 0, bookmark.length);
        sendingBookmark = new Bookmark[0];
        if (bl) {
            Bookmark.sendAllBookmark();
        }
        if (bl2) {
            Bookmark.sendRecoverFlag();
        }
    }

    private static void deleteBookmark(Bookmark[] bookmarkArray, Bookmark bookmark) {
        usedFlg = new boolean[bookmarkArray.length];
        Bookmark.deleteBookmark2(bookmarkArray, bookmark);
    }

    private static void deleteBookmark2(Bookmark[] bookmarkArray, Bookmark bookmark) {
        int n;
        int n2;
        for (n2 = 0; n2 < bookmarkArray.length; ++n2) {
            if ((bookmark.serverBID == 0 || bookmarkArray[n2].serverBID != bookmark.serverBID) && (bookmark.clientBID == 0 || bookmarkArray[n2].clientBID != bookmark.clientBID)) continue;
            bookmarkArray[n2].state = 2;
            for (n = 0; n < sendingBookmark.length; ++n) {
                if ((bookmark.serverBID == 0 || Bookmark.sendingBookmark[n].serverBID != bookmark.serverBID) && (bookmark.clientBID == 0 || Bookmark.sendingBookmark[n].clientBID != bookmark.clientBID)) continue;
                Bookmark.sendingBookmark[n].state = 2;
            }
            break;
        }
        for (n2 = 0; n2 < bookmarkArray.length; ++n2) {
            if ((bookmark.serverBID == 0 || bookmarkArray[n2].folderServerBID != bookmark.serverBID) && (bookmark.clientBID == 0 || bookmarkArray[n2].folderClientBID != bookmark.clientBID) || usedFlg[n2]) continue;
            if (bookmarkArray[n2].isFolder) {
                Bookmark.usedFlg[n2] = true;
                Bookmark.deleteBookmark2(bookmarkArray, bookmarkArray[n2]);
                continue;
            }
            bookmarkArray[n2].state = 2;
            for (n = 0; n < sendingBookmark.length; ++n) {
                if ((bookmarkArray[n2].serverBID == 0 || Bookmark.sendingBookmark[n].serverBID != bookmarkArray[n2].serverBID) && (bookmarkArray[n2].clientBID == 0 || Bookmark.sendingBookmark[n].clientBID != bookmarkArray[n2].clientBID)) continue;
                Bookmark.sendingBookmark[n].state = 2;
            }
        }
    }

    static void deleteBookmarkClient(Bookmark bookmark) {
        int n;
        Bookmark.deleteBookmark(Bookmark.bookmark, bookmark);
        Bookmark[] bookmarkArray = new Bookmark[Bookmark.bookmark.length];
        Bookmark[] bookmarkArray2 = new Bookmark[Bookmark.bookmark.length];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < Bookmark.bookmark.length; ++n) {
            if (Bookmark.bookmark[n].state != 2) {
                bookmarkArray[n2++] = Bookmark.bookmark[n];
                continue;
            }
            if (Bookmark.bookmark[n].serverBID == 0) continue;
            Bookmark.bookmark[n].state = 1;
            bookmarkArray2[n3++] = Bookmark.bookmark[n];
        }
        Bookmark.bookmark = new Bookmark[n2];
        System.arraycopy(bookmarkArray, 0, Bookmark.bookmark, 0, Bookmark.bookmark.length);
        bookmarkArray = new Bookmark[sendingBookmark.length];
        n2 = 0;
        for (n = 0; n < sendingBookmark.length; ++n) {
            if (Bookmark.sendingBookmark[n].state == 2) continue;
            bookmarkArray[n2++] = sendingBookmark[n];
        }
        sendingBookmark = new Bookmark[n2 + n3];
        System.arraycopy(bookmarkArray, 0, sendingBookmark, 0, n2);
        System.arraycopy(bookmarkArray2, 0, sendingBookmark, n2, n3);
    }

    Bookmark() {
    }

    Bookmark(int n) {
        this.array = new int[n];
    }
}

